/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sdb;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.sdb.BatchDeleteAttributesCommand;
import org.apache.camel.component.aws.sdb.BatchPutAttributesCommand;
import org.apache.camel.component.aws.sdb.DeleteAttributesCommand;
import org.apache.camel.component.aws.sdb.DeleteDomainCommand;
import org.apache.camel.component.aws.sdb.DomainMetadataCommand;
import org.apache.camel.component.aws.sdb.GetAttributesCommand;
import org.apache.camel.component.aws.sdb.ListDomainsCommand;
import org.apache.camel.component.aws.sdb.PutAttributesCommand;
import org.apache.camel.component.aws.sdb.SdbConfiguration;
import org.apache.camel.component.aws.sdb.SdbEndpoint;
import org.apache.camel.component.aws.sdb.SdbOperations;
import org.apache.camel.component.aws.sdb.SelectCommand;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.URISupport;

public class SdbProducer
extends DefaultProducer {
    public SdbProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case BatchDeleteAttributes: {
                new BatchDeleteAttributesCommand(this.getEndpoint().getSdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case BatchPutAttributes: {
                new BatchPutAttributesCommand(this.getEndpoint().getSdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case DeleteAttributes: {
                new DeleteAttributesCommand(this.getEndpoint().getSdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case DeleteDomain: {
                new DeleteDomainCommand(this.getEndpoint().getSdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case DomainMetadata: {
                new DomainMetadataCommand(this.getEndpoint().getSdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case GetAttributes: {
                new GetAttributesCommand(this.getEndpoint().getSdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case ListDomains: {
                new ListDomainsCommand(this.getEndpoint().getSdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case PutAttributes: {
                new PutAttributesCommand(this.getEndpoint().getSdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            case Select: {
                new SelectCommand(this.getEndpoint().getSdbClient(), this.getConfiguration(), exchange).execute();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private SdbOperations determineOperation(Exchange exchange) {
        SdbOperations operation = (SdbOperations)((Object)exchange.getIn().getHeader("CamelAwsSdbOperation", SdbOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected SdbConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        return "SdbProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }

    public SdbEndpoint getEndpoint() {
        return (SdbEndpoint)super.getEndpoint();
    }
}

