/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.ssh.SshEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class SshProducer
extends DefaultProducer {
    private SshEndpoint endpoint;

    public SshProducer(SshEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String command = (String)in.getMandatoryBody(String.class);
        try {
            byte[] result = this.endpoint.sendExecCommand(command);
            exchange.getOut().setBody((Object)result);
        }
        catch (Exception e) {
            throw new CamelExchangeException("Cannot execute command: " + command, exchange, (Throwable)e);
        }
        exchange.getOut().getHeaders().putAll(in.getHeaders());
        exchange.getOut().setAttachments(in.getAttachments());
    }
}

