/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb.converters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.Map;
import org.apache.camel.Converter;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class MongoDbBasicConverters {
    private static final transient Logger LOG = LoggerFactory.getLogger(MongoDbBasicConverters.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    private MongoDbBasicConverters() {
    }

    @Converter
    public static DBObject fromMapToDBObject(Map<?, ?> map) {
        return new BasicDBObject(map);
    }

    @Converter
    public static Map<String, Object> fromBasicDBObjectToMap(BasicDBObject basicDbObject) {
        return basicDbObject;
    }

    @Converter
    public static DBObject fromStringToDBObject(String s) {
        DBObject answer = null;
        try {
            answer = (DBObject)JSON.parse((String)s);
        }
        catch (Exception e) {
            LOG.warn("String -> DBObject conversion selected, but the following exception occurred. Returning null.", (Throwable)e);
        }
        return answer;
    }

    @Converter
    public static DBObject fromAnyObjectToDBObject(Object value) {
        BasicDBObject answer;
        try {
            Map m = (Map)objectMapper.convertValue(value, Map.class);
            answer = new BasicDBObject(m);
        }
        catch (Exception e) {
            LOG.warn("Conversion has fallen back to generic Object -> DBObject, but unable to convert type {}. Returning null.", (Object)value.getClass().getCanonicalName());
            return null;
        }
        return answer;
    }
}

