/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;

public final class PGPDataFormatUtil {
    private PGPDataFormatUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PGPPublicKey findPublicKey(CamelContext context, String filename, String userid) throws IOException, PGPException, NoSuchProviderException {
        PGPPublicKey privKey;
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)context.getClassResolver(), (String)filename);
        try {
            privKey = PGPDataFormatUtil.findPublicKey(context, is, userid);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        return privKey;
    }

    public static PGPPublicKey findPublicKey(CamelContext context, InputStream input, String userid) throws IOException, PGPException, NoSuchProviderException {
        PGPPublicKeyRingCollection pgpSec = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input));
        Iterator keyRingIter = pgpSec.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)keyRingIter.next();
            Iterator keyIter = keyRing.getPublicKeys();
            String keyUserId = null;
            while (keyIter.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)keyIter.next();
                Iterator iterator = key.getUserIDs();
                while (iterator.hasNext()) {
                    keyUserId = (String)iterator.next();
                }
                if (!key.isEncryptionKey() || keyUserId == null || !keyUserId.contains(userid)) continue;
                return key;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PGPPrivateKey findPrivateKey(CamelContext context, String keychainFilename, InputStream encryptedInput, String passphrase) throws IOException, PGPException, NoSuchProviderException {
        InputStream keyChainInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)context.getClassResolver(), (String)keychainFilename);
        PGPPrivateKey privKey = null;
        try {
            privKey = PGPDataFormatUtil.findPrivateKey(context, keyChainInputStream, encryptedInput, passphrase);
        }
        finally {
            IOHelper.close((Closeable)keyChainInputStream);
        }
        return privKey;
    }

    public static PGPPrivateKey findPrivateKey(CamelContext context, InputStream keyringInput, InputStream encryptedInput, String passphrase) throws IOException, PGPException, NoSuchProviderException {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyringInput));
        PGPObjectFactory factory = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)encryptedInput));
        Object o = factory.nextObject();
        PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)factory.nextObject();
        encryptedInput.reset();
        Iterator encryptedDataObjects = enc.getEncryptedDataObjects();
        PGPPrivateKey privateKey = null;
        while (privateKey == null && encryptedDataObjects.hasNext()) {
            PGPPublicKeyEncryptedData encryptedData = (PGPPublicKeyEncryptedData)encryptedDataObjects.next();
            PGPSecretKey pgpSecKey = pgpSec.getSecretKey(encryptedData.getKeyID());
            privateKey = pgpSecKey.extractPrivateKey(passphrase.toCharArray(), "BC");
        }
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] clearData, String fileName, int algorithm) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(algorithm);
        OutputStream cos = comData.open((OutputStream)bOut);
        PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
        OutputStream pOut = lData.open(cos, 'b', fileName, (long)clearData.length, new Date());
        try {
            pOut.write(clearData);
        }
        finally {
            IOHelper.close((Closeable)pOut);
            comData.close();
        }
        return bOut.toByteArray();
    }
}

