/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.javaspace;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.javaspace.JavaSpaceComponent;
import org.apache.camel.component.javaspace.JavaSpaceConsumer;
import org.apache.camel.component.javaspace.JavaSpaceProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;

public class JavaSpaceEndpoint
extends DefaultEndpoint {
    private final String remaining;
    private final Map<?, ?> parameters;
    private int concurrentConsumers = 1;
    private String spaceName;
    private boolean transactional;
    private long transactionTimeout = Long.MAX_VALUE;
    private String verb = "take";
    private String templateId;

    public JavaSpaceEndpoint(String endpointUri, String remaining, Map<?, ?> parameters, JavaSpaceComponent component) {
        super(endpointUri, (Component)component);
        this.remaining = remaining;
        this.parameters = parameters;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public String getVerb() {
        return this.verb;
    }

    public void setVerb(String verb) {
        this.verb = verb;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public Producer createProducer() throws Exception {
        return new JavaSpaceProducer(this);
    }

    public DefaultExchange createExchange() {
        return new DefaultExchange(this.getCamelContext(), this.getExchangePattern());
    }

    public boolean isSingleton() {
        return true;
    }

    public String getRemaining() {
        return this.remaining;
    }

    public Map<?, ?> getParameters() {
        return this.parameters;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new JavaSpaceConsumer(this, processor);
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }
}

