/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.LinkedList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.model.RouteDefinition;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="camel", name="route-list", description="List Camel routes.")
public class RouteList
extends OsgiCommandSupport {
    protected static final String HEADER_FORMAT = "%-20s %-20s %-20s";
    protected static final String OUTPUT_FORMAT = "[%-18s] [%-18s] [%-18s]";
    protected static final String UNKNOWN = "Unknown";
    protected static final String ROUTE_ID = "Route Id";
    protected static final String CONTEXT_ID = "Context Name";
    protected static final String STATUS = "Status";
    @Argument(index=0, name="name", description="The Camel context name where to look for the route", required=false, multiValued=false)
    String name;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    protected Object doExecute() throws Exception {
        System.out.println(String.format(HEADER_FORMAT, ROUTE_ID, CONTEXT_ID, STATUS));
        List<Object> camelContexts = new LinkedList();
        if (this.name != null && this.camelController.getCamelContext(this.name) != null) {
            camelContexts.add(this.camelController.getCamelContext(this.name));
        } else {
            camelContexts = this.camelController.getCamelContexts();
        }
        for (CamelContext camelContext : camelContexts) {
            List<RouteDefinition> routeDefinitions = this.camelController.getRouteDefinitions(camelContext.getName());
            if (routeDefinitions == null || routeDefinitions.isEmpty()) continue;
            for (RouteDefinition routeDefinition : routeDefinitions) {
                String contextName = camelContext.getName();
                ServiceStatus status = camelContext.getRouteStatus(routeDefinition.getId());
                System.out.println(String.format(OUTPUT_FORMAT, routeDefinition.getId(), contextName, status != null ? status.name() : UNKNOWN));
            }
        }
        return null;
    }
}

