/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.twitter.Twitter4JFactory;
import org.apache.camel.component.twitter.TwitterComponent;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.Twitter4JConsumer;
import org.apache.camel.component.twitter.consumer.TwitterConsumerPolling;
import org.apache.camel.component.twitter.data.EndpointType;
import org.apache.camel.impl.DefaultPollingEndpoint;

public class TwitterEndpointPolling
extends DefaultPollingEndpoint
implements TwitterEndpoint {
    private TwitterConfiguration properties;

    public TwitterEndpointPolling(String uri, TwitterComponent component, TwitterConfiguration properties) {
        super(uri, (Component)component);
        this.properties = properties;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Twitter4JConsumer twitter4jConsumer = Twitter4JFactory.getConsumer(this, this.getEndpointUri());
        TwitterConsumerPolling tc = new TwitterConsumerPolling(this, processor, twitter4jConsumer);
        this.configureConsumer((Consumer)tc);
        return tc;
    }

    public Producer createProducer() throws Exception {
        return Twitter4JFactory.getProducer(this, this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public TwitterConfiguration getProperties() {
        return this.properties;
    }

    @Override
    public EndpointType getEndpointType() {
        return EndpointType.POLLING;
    }

    public void shutdown() throws Exception {
        super.shutdown();
        this.properties.getTwitter().shutdown();
    }
}

