/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.component.hl7.HL7Converter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;

public class HL7DataFormat
implements DataFormat {
    private boolean validate = true;

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        Message message = (Message)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Message.class, (Object)body);
        String encoded = HL7Converter.encode(message, this.validate);
        outputStream.write(encoded.getBytes());
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        String body = (String)ExchangeHelper.convertToMandatoryType((Exchange)exchange, String.class, (Object)inputStream);
        Message message = HL7Converter.parse(body, this.validate);
        Terser terser = new Terser(message);
        exchange.getOut().setHeader("CamelHL7SendingApplication", (Object)terser.get("MSH-3"));
        exchange.getOut().setHeader("CamelHL7SendingFacility", (Object)terser.get("MSH-4"));
        exchange.getOut().setHeader("CamelHL7ReceivingApplication", (Object)terser.get("MSH-5"));
        exchange.getOut().setHeader("CamelHL7ReceivingFacility", (Object)terser.get("MSH-6"));
        exchange.getOut().setHeader("CamelHL7Timestamp", (Object)terser.get("MSH-7"));
        exchange.getOut().setHeader("CamelHL7Security", (Object)terser.get("MSH-8"));
        exchange.getOut().setHeader("CamelHL7MessageType", (Object)terser.get("MSH-9-1"));
        exchange.getOut().setHeader("CamelHL7TriggerEvent", (Object)terser.get("MSH-9-2"));
        exchange.getOut().setHeader("CamelHL7MessageControl", (Object)terser.get("MSH-10"));
        exchange.getOut().setHeader("CamelHL7ProcessingId", (Object)terser.get("MSH-11"));
        exchange.getOut().setHeader("CamelHL7VersionId", (Object)terser.get("MSH-12"));
        return message;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }
}

