/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.support.ExpressionSupport;
import org.apache.camel.util.ExchangeHelper;

public class GroovyExpression
extends ExpressionSupport {
    private final String text;

    public GroovyExpression(String text) {
        this.text = text;
    }

    public String toString() {
        return "groovy: " + this.text;
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return "groovy: " + this.text;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        ClassLoader cl = exchange.getContext().getApplicationContextClassLoader();
        GroovyShell shell = cl != null ? new GroovyShell(cl) : new GroovyShell();
        Script script = shell.parse(this.text);
        this.configure(exchange, script.getBinding());
        Object value = script.evaluate(this.text);
        return (T)exchange.getContext().getTypeConverter().convertTo(type, value);
    }

    private void configure(Exchange exchange, final Binding binding) {
        ExchangeHelper.populateVariableMap((Exchange)exchange, (Map)new AbstractMap<String, Object>(){

            @Override
            public Object put(String key, Object value) {
                binding.setProperty(key, value);
                return null;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return Collections.emptySet();
            }
        });
    }
}

