/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stringtemplate;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.util.ExchangeHelper;

public class StringTemplateEndpoint
extends ResourceEndpoint {
    public StringTemplateEndpoint() {
    }

    public StringTemplateEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component, resourceUri);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected void onExchange(Exchange exchange) throws Exception {
        StringWriter buffer = new StringWriter();
        Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange);
        String text = (String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)this.getResourceAsInputStream());
        StringTemplate template = new StringTemplate(text);
        template.setAttributes(variableMap);
        this.log.debug("StringTemplate is writing using attributes: {}", (Object)variableMap);
        template.write((StringTemplateWriter)new AutoIndentWriter((Writer)buffer));
        Message out = exchange.getOut();
        out.setBody((Object)buffer.toString());
        out.setHeaders(exchange.getIn().getHeaders());
        out.setHeader("CamelStringTemplateResourceUri", (Object)this.getResourceUri());
        out.setAttachments(exchange.getIn().getAttachments());
    }
}

