/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperEndpoint;
import org.apache.camel.impl.DefaultComponent;

public class ZooKeeperComponent
extends DefaultComponent {
    private ZooKeeperConfiguration configuration;

    public ZooKeeperComponent() {
    }

    public ZooKeeperComponent(CamelContext context) {
        super(context);
    }

    public ZooKeeperComponent(ZooKeeperConfiguration configuration) {
        this.configuration = configuration;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (this.getCamelContext() == null) {
            throw new CamelException("No Camel context has been provided to this zookeeper component");
        }
        ZooKeeperConfiguration config = this.getConfiguration().copy();
        this.extractConfigFromUri(uri, config);
        this.setProperties(config, parameters);
        return new ZooKeeperEndpoint(uri, this, config);
    }

    private void extractConfigFromUri(String remaining, ZooKeeperConfiguration config) throws URISyntaxException {
        URI u = new URI(remaining);
        config.addZookeeperServer(u.getHost() + (u.getPort() != -1 ? ":" + u.getPort() : ""));
        config.setPath(u.getPath());
    }

    public ZooKeeperConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ZooKeeperConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(ZooKeeperConfiguration configuration) {
        this.configuration = configuration;
    }
}

