/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.RuntimeCamelException;

public class ZooKeeperConfiguration
implements Cloneable {
    private int timeout = 5000;
    private long backoff = 5000L;
    private List<String> servers;
    private boolean changed;
    private int sessionId;
    private byte[] password;
    private String path;
    private boolean awaitExistence = true;
    private boolean repeat;
    private boolean listChildren;
    private boolean shouldCreate;
    private String createMode;
    private boolean sendEmptyMessageOnDelete = true;

    public void addZookeeperServer(String server) {
        if (this.servers == null) {
            this.servers = new ArrayList<String>();
        }
        this.servers.add(server);
        this.changed = true;
    }

    public List<String> getServers() {
        return this.servers;
    }

    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        this.changed = true;
    }

    public boolean listChildren() {
        return this.listChildren;
    }

    public void setListChildren(boolean listChildren) {
        this.listChildren = listChildren;
    }

    public void clearChanged() {
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public String getConnectString() {
        StringBuilder b = new StringBuilder();
        for (String server : this.servers) {
            b.append(server).append(",");
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    public byte[] getSessionPassword() {
        return this.password;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean shouldRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public ZooKeeperConfiguration copy() {
        try {
            return (ZooKeeperConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public boolean shouldAwaitExistence() {
        return this.awaitExistence;
    }

    public void setAwaitExistence(boolean awaitExistence) {
        this.awaitExistence = awaitExistence;
    }

    public long getBackoff() {
        return this.backoff;
    }

    public void setBackoff(long backoff) {
        this.backoff = backoff;
    }

    public void setCreate(boolean shouldCreate) {
        this.shouldCreate = shouldCreate;
    }

    public boolean shouldCreate() {
        return this.shouldCreate;
    }

    public String getCreateMode() {
        return this.createMode;
    }

    public void setCreateMode(String createMode) {
        this.createMode = createMode;
    }

    public boolean isSendEmptyMessageOnDelete() {
        return this.sendEmptyMessageOnDelete;
    }

    public void setSendEmptyMessageOnDelete(boolean sendEmptyMessageOnDelete) {
        this.sendEmptyMessageOnDelete = sendEmptyMessageOnDelete;
    }
}

