/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.guava.eventbus;

import com.google.common.eventbus.Subscribe;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.guava.eventbus.GuavaEventBusEndpoint;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelEventHandler {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelEventHandler.class);
    private final GuavaEventBusEndpoint eventBusEndpoint;
    private final AsyncProcessor processor;
    private final Class<?> eventClass;

    public CamelEventHandler(GuavaEventBusEndpoint eventBusEndpoint, Processor processor, Class<?> eventClass) {
        ObjectHelper.notNull((Object)((Object)eventBusEndpoint), (String)"eventBusEndpoint");
        ObjectHelper.notNull((Object)processor, (String)"processor");
        this.eventBusEndpoint = eventBusEndpoint;
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
        this.eventClass = eventClass;
    }

    @Subscribe
    public void eventReceived(Object event) throws Exception {
        LOG.trace("Received event: {}");
        if (this.eventClass == null || this.eventClass.isAssignableFrom(event.getClass())) {
            Exchange exchange = this.eventBusEndpoint.createExchange(event);
            LOG.debug("Processing event: {}", event);
            this.processor.process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                }
            });
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Cannot process event: {} as its class type: {} is not assignable with: {}", new Object[]{event, event.getClass().getName(), this.eventClass.getName()});
        }
    }
}

