/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.http4.HttpConsumer;
import org.apache.camel.component.http4.HttpMessage;
import org.apache.camel.component.http4.helper.HttpHelper;
import org.apache.camel.impl.DefaultExchange;

public class CamelServlet
extends HttpServlet {
    private static final long serialVersionUID = -7061982839117697829L;
    private ConcurrentMap<String, HttpConsumer> consumers = new ConcurrentHashMap<String, HttpConsumer>();

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HttpConsumer consumer = this.resolve(request);
            if (consumer == null) {
                response.sendError(404);
                return;
            }
            if ("TRACE".equals(request.getMethod()) && !consumer.isTraceEnabled()) {
                response.sendError(405);
            }
            DefaultExchange exchange = new DefaultExchange((Endpoint)consumer.getEndpoint(), ExchangePattern.InOut);
            if (consumer.getEndpoint().isBridgeEndpoint()) {
                exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            }
            if (consumer.getEndpoint().isDisableStreamCache()) {
                exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
            }
            HttpHelper.setCharsetFromContentType(request.getContentType(), (Exchange)exchange);
            exchange.setIn((Message)new HttpMessage((Exchange)exchange, request, response));
            consumer.getProcessor().process((Exchange)exchange);
            consumer.getBinding().writeResponse((Exchange)exchange, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    protected HttpConsumer resolve(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        HttpConsumer answer = (HttpConsumer)((Object)this.consumers.get(path));
        if (answer == null) {
            for (String key : this.consumers.keySet()) {
                if (!((HttpConsumer)((Object)this.consumers.get(key))).getEndpoint().isMatchOnUriPrefix() || !path.startsWith(key)) continue;
                answer = (HttpConsumer)((Object)this.consumers.get(key));
                break;
            }
        }
        return answer;
    }

    public void connect(HttpConsumer consumer) {
        this.consumers.put(consumer.getPath(), consumer);
    }

    public void disconnect(HttpConsumer consumer) {
        this.consumers.remove(consumer.getPath());
    }
}

