/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.eventadmin;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.eventadmin.EventAdminEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.CamelContextHelper;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class EventAdminProducer
extends DefaultProducer {
    private final EventAdminEndpoint endpoint;
    private ServiceTracker tracker;

    public EventAdminProducer(EventAdminEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.tracker = new ServiceTracker(endpoint.getComponent().getBundleContext(), EventAdmin.class.getName(), null);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.tracker.open();
    }

    protected void doStop() throws Exception {
        this.tracker.close();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        EventAdmin admin = (EventAdmin)this.tracker.getService();
        if (admin != null) {
            Event event = this.getEvent(exchange);
            if (this.endpoint.isSend()) {
                admin.sendEvent(event);
            } else {
                admin.postEvent(event);
            }
        } else {
            throw new CamelExchangeException("EventAdmin service not present", exchange);
        }
    }

    protected String getTopic(Exchange exchange) {
        Message in = exchange.getIn();
        String topic = (String)in.getHeader("CamelEventAdminTopic", String.class);
        if (topic != null) {
            in.removeHeader("CamelEventAdminTopic");
        }
        if (topic == null) {
            topic = this.endpoint.getTopic();
        }
        return topic;
    }

    protected Event getEvent(Exchange exchange) {
        Message in = exchange.getIn();
        CamelContext context = this.endpoint.getCamelContext();
        Event event = (Event)context.getTypeConverter().convertTo(Event.class, exchange, in.getBody());
        if (event == null) {
            String topic = this.getTopic(exchange);
            Dictionary<?, ?> props = this.getProperties(exchange);
            event = new Event(topic, props);
        }
        return event;
    }

    protected Dictionary<?, ?> getProperties(Exchange exchange) {
        Message in = exchange.getIn();
        CamelContext context = this.endpoint.getCamelContext();
        Map map = (Map)context.getTypeConverter().convertTo(Map.class, exchange, in.getBody());
        Hashtable dict = new Hashtable();
        for (Map.Entry entry : map.entrySet()) {
            String keyString = (String)CamelContextHelper.convertTo((CamelContext)context, String.class, entry.getKey());
            if (keyString == null) continue;
            Object val = entry.getValue();
            ((Dictionary)dict).put(keyString, val);
        }
        return dict;
    }
}

