/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.routebox;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.routebox.RouteboxComponent;
import org.apache.camel.component.routebox.strategy.RouteboxDispatchStrategy;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteboxConfiguration {
    private static final transient Logger LOG = LoggerFactory.getLogger(RouteboxConfiguration.class);
    private URI uri;
    private String authority;
    private String endpointName;
    private URI consumerUri;
    private URI producerUri;
    private RouteboxDispatchStrategy dispatchStrategy;
    private Map<String, String> dispatchMap;
    private CamelContext innerContext;
    private List<RouteBuilder> routeBuilders = new ArrayList<RouteBuilder>();
    private Registry innerRegistry;
    private boolean forkContext = true;
    private boolean local = true;
    private long connectionTimeout = 20000L;
    private long pollInterval = 1000L;
    private String innerProtocol;
    private int threads = 20;
    private int queueSize;
    private ProducerTemplate innerProducerTemplate;
    private boolean sendToConsumer = true;

    public RouteboxConfiguration() {
    }

    public RouteboxConfiguration(URI uri) {
        this();
        this.uri = uri;
    }

    public void parseURI(URI uri, Map<String, Object> parameters, RouteboxComponent component) throws Exception {
        String protocol = uri.getScheme();
        if (!protocol.equalsIgnoreCase("routebox")) {
            throw new IllegalArgumentException("Unrecognized protocol: " + protocol + " for uri: " + uri);
        }
        this.setUri(uri);
        this.setAuthority(uri.getAuthority());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Authority: {}", (Object)uri.getAuthority());
        }
        this.setEndpointName(this.getAuthority());
        if (parameters.containsKey("threads")) {
            this.setThreads(Integer.valueOf((String)parameters.get("threads")));
        }
        if (parameters.containsKey("forkContext") && !Boolean.valueOf((String)parameters.get("forkContext")).booleanValue()) {
            this.setForkContext(false);
        }
        if (parameters.containsKey("innerProtocol")) {
            this.setInnerProtocol((String)parameters.get("innerProtocol"));
            if (!this.innerProtocol.equalsIgnoreCase("seda") && !this.innerProtocol.equalsIgnoreCase("direct")) {
                throw new IllegalArgumentException("Unrecognized inner protocol: " + this.innerProtocol + " for uri: " + uri);
            }
        } else {
            this.setInnerProtocol("direct");
        }
        if (parameters.containsKey("sendToConsumer") && !Boolean.valueOf((String)parameters.get("sendToConsumer")).booleanValue()) {
            this.setSendToConsumer(false);
        }
        if (parameters.containsKey("connectionTimeout")) {
            this.setConnectionTimeout(Long.parseLong((String)parameters.get("connectionTimeout")));
        }
        if (parameters.containsKey("pollInterval")) {
            this.setConnectionTimeout(Long.parseLong((String)parameters.get("pollInterval")));
        }
        if (parameters.containsKey("routeBuilders")) {
            this.routeBuilders = (List)component.resolveAndRemoveReferenceParameter(parameters, "routeBuilders", List.class);
        }
        if (parameters.containsKey("innerRegistry")) {
            this.innerRegistry = (Registry)component.resolveAndRemoveReferenceParameter(parameters, "innerRegistry", Registry.class);
        }
        this.innerContext = this.isForkContext() ? (this.innerRegistry != null ? (CamelContext)component.resolveAndRemoveReferenceParameter(parameters, "innerContext", CamelContext.class, new DefaultCamelContext(this.innerRegistry)) : (CamelContext)component.resolveAndRemoveReferenceParameter(parameters, "innerContext", CamelContext.class, new DefaultCamelContext())) : component.getCamelContext();
        this.innerProducerTemplate = this.innerContext.createProducerTemplate();
        this.setQueueSize((Integer)component.getAndRemoveParameter(parameters, "size", Integer.class, 0));
        this.consumerUri = (URI)component.resolveAndRemoveReferenceParameter(parameters, "consumerUri", URI.class, new URI("routebox:" + this.getEndpointName()));
        this.producerUri = (URI)component.resolveAndRemoveReferenceParameter(parameters, "producerUri", URI.class, new URI("routebox:" + this.getEndpointName()));
        this.dispatchStrategy = (RouteboxDispatchStrategy)component.resolveAndRemoveReferenceParameter(parameters, "dispatchStrategy", RouteboxDispatchStrategy.class, null);
        this.dispatchMap = (Map)component.resolveAndRemoveReferenceParameter(parameters, "dispatchMap", HashMap.class, new HashMap());
        if (this.dispatchStrategy == null && this.dispatchMap == null) {
            LOG.warn("No Routebox Dispatch Map or Strategy has been set. Routebox may not have more than one inner route.");
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public CamelContext getInnerContext() {
        return this.innerContext;
    }

    public void setInnerContext(CamelContext innerContext) {
        this.innerContext = innerContext;
    }

    public void setRouteBuilders(List<RouteBuilder> routeBuilders) {
        this.routeBuilders = routeBuilders;
    }

    public List<RouteBuilder> getRouteBuilders() {
        return this.routeBuilders;
    }

    public void setForkContext(boolean forkContext) {
        this.forkContext = forkContext;
    }

    public boolean isForkContext() {
        return this.forkContext;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setProducerUri(URI producerUri) {
        this.producerUri = producerUri;
    }

    public URI getProducerUri() {
        return this.producerUri;
    }

    public void setConsumerUri(URI consumerUri) {
        this.consumerUri = consumerUri;
    }

    public URI getConsumerUri() {
        return this.consumerUri;
    }

    public void setDispatchStrategy(RouteboxDispatchStrategy dispatchStrategy) {
        this.dispatchStrategy = dispatchStrategy;
    }

    public RouteboxDispatchStrategy getDispatchStrategy() {
        return this.dispatchStrategy;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setInnerProducerTemplate(ProducerTemplate innerProducerTemplate) {
        this.innerProducerTemplate = innerProducerTemplate;
    }

    public ProducerTemplate getInnerProducerTemplate() {
        return this.innerProducerTemplate;
    }

    public void setInnerProtocol(String innerProtocol) {
        this.innerProtocol = innerProtocol;
    }

    public String getInnerProtocol() {
        return this.innerProtocol;
    }

    public void setInnerRegistry(Registry innerRegistry) {
        this.innerRegistry = innerRegistry;
    }

    public Registry getInnerRegistry() {
        return this.innerRegistry;
    }

    public void setSendToConsumer(boolean sendToConsumer) {
        this.sendToConsumer = sendToConsumer;
    }

    public boolean isSendToConsumer() {
        return this.sendToConsumer;
    }

    public void setDispatchMap(Map<String, String> dispatchMap) {
        this.dispatchMap = dispatchMap;
    }

    public Map<String, String> getDispatchMap() {
        return this.dispatchMap;
    }
}

