/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsFileSystemType;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.HdfsInputStream;
import org.apache.camel.component.hdfs.HdfsOutputStream;
import org.apache.camel.component.hdfs.HdfsWritableFactories;
import org.apache.camel.component.hdfs.Holder;
import org.apache.camel.util.IOHelper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayFile;
import org.apache.hadoop.io.BloomMapFile;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public enum HdfsFileType {
    NORMAL_FILE{

        @Override
        public long append(HdfsOutputStream hdfsostr, Object key, Object value, TypeConverter typeConverter) {
            long l;
            InputStream is = null;
            try {
                is = (InputStream)typeConverter.convertTo(InputStream.class, value);
                l = 1.copyBytes(is, (OutputStream)((FSDataOutputStream)hdfsostr.getOut()), 4096, false);
            }
            catch (IOException ex) {
                try {
                    throw new RuntimeCamelException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
            }
            IOHelper.close((Closeable)is);
            return l;
        }

        @Override
        public long next(HdfsInputStream hdfsistr, Holder<Object> key, Holder<Object> value) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(hdfsistr.getChunkSize());
                byte[] buf = new byte[4096];
                int bytesRead = ((InputStream)hdfsistr.getIn()).read(buf);
                if (bytesRead >= 0) {
                    bos.write(buf, 0, bytesRead);
                    key.value = null;
                    value.value = bos;
                    return bytesRead;
                }
                key.value = null;
                value.value = null;
                return 0L;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Closeable createOutputStream(String hdfsPath, HdfsConfiguration configuration) {
            try {
                HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                FSDataOutputStream rout = !configuration.isAppend() ? hdfsInfo.getFileSystem().create(hdfsInfo.getPath(), configuration.isOverwrite(), configuration.getBufferSize(), configuration.getReplication(), configuration.getBlockSize(), new Progressable(){

                    public void progress() {
                    }
                }) : hdfsInfo.getFileSystem().append(hdfsInfo.getPath(), configuration.getBufferSize(), new Progressable(){

                    public void progress() {
                    }
                });
                return rout;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Closeable createInputStream(String hdfsPath, HdfsConfiguration configuration) {
            try {
                FileInputStream rin;
                if (configuration.getFileSystemType().equals((Object)HdfsFileSystemType.LOCAL)) {
                    HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                    rin = hdfsInfo.getFileSystem().open(hdfsInfo.getPath());
                } else {
                    rin = new FileInputStream(this.getHfdsFileToTmpFile(hdfsPath, configuration));
                }
                return rin;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        private File getHfdsFileToTmpFile(String hdfsPath, HdfsConfiguration configuration) {
            try {
                String fname = hdfsPath.substring(hdfsPath.lastIndexOf(47));
                File outputDest = File.createTempFile(fname, ".hdfs");
                if (outputDest.exists()) {
                    outputDest.delete();
                }
                HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                FileSystem fileSystem = hdfsInfo.getFileSystem();
                FileUtil.copy((FileSystem)fileSystem, (Path)new Path(hdfsPath), (File)outputDest, (boolean)false, (Configuration)fileSystem.getConf());
                try {
                    FileUtil.copyMerge((FileSystem)fileSystem, (Path)new Path(hdfsPath), (FileSystem)FileSystem.getLocal((Configuration)new Configuration()), (Path)new Path(outputDest.toURI()), (boolean)false, (Configuration)fileSystem.getConf(), null);
                }
                catch (IOException e) {
                    return outputDest;
                }
                return new File(outputDest, fname);
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
    }
    ,
    SEQUENCE_FILE{

        @Override
        public long append(HdfsOutputStream hdfsostr, Object key, Object value, TypeConverter typeConverter) {
            try {
                Holder keySize = new Holder();
                Writable keyWritable = HdfsFileType.getWritable(key, typeConverter, keySize);
                Holder valueSize = new Holder();
                Writable valueWritable = HdfsFileType.getWritable(value, typeConverter, valueSize);
                SequenceFile.Writer writer = (SequenceFile.Writer)hdfsostr.getOut();
                writer.append(keyWritable, valueWritable);
                writer.sync();
                return (Integer)keySize.value + (Integer)valueSize.value;
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public long next(HdfsInputStream hdfsistr, Holder<Object> key, Holder<Object> value) {
            try {
                SequenceFile.Reader reader = (SequenceFile.Reader)hdfsistr.getIn();
                Holder keySize = new Holder();
                Writable keyWritable = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)new Configuration());
                Holder valueSize = new Holder();
                Writable valueWritable = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)new Configuration());
                if (reader.next(keyWritable, valueWritable)) {
                    key.value = HdfsFileType.getObject(keyWritable, keySize);
                    value.value = HdfsFileType.getObject(valueWritable, valueSize);
                    return (Integer)keySize.value + (Integer)valueSize.value;
                }
                return 0L;
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Closeable createOutputStream(String hdfsPath, HdfsConfiguration configuration) {
            try {
                HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                Class<? extends WritableComparable> keyWritableClass = configuration.getKeyType().getWritableClass();
                Class<? extends WritableComparable> valueWritableClass = configuration.getValueType().getWritableClass();
                SequenceFile.Writer rout = SequenceFile.createWriter((FileSystem)hdfsInfo.getFileSystem(), (Configuration)hdfsInfo.getConf(), (Path)hdfsInfo.getPath(), keyWritableClass, valueWritableClass, (int)configuration.getBufferSize(), (short)configuration.getReplication(), (long)configuration.getBlockSize(), (SequenceFile.CompressionType)configuration.getCompressionType(), (CompressionCodec)configuration.getCompressionCodec().getCodec(), (Progressable)new Progressable(){

                    public void progress() {
                    }
                }, (SequenceFile.Metadata)new SequenceFile.Metadata());
                return rout;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Closeable createInputStream(String hdfsPath, HdfsConfiguration configuration) {
            try {
                HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                SequenceFile.Reader rin = new SequenceFile.Reader(hdfsInfo.getFileSystem(), hdfsInfo.getPath(), hdfsInfo.getConf());
                return rin;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
    }
    ,
    MAP_FILE{

        @Override
        public long append(HdfsOutputStream hdfsostr, Object key, Object value, TypeConverter typeConverter) {
            try {
                Holder keySize = new Holder();
                Writable keyWritable = HdfsFileType.getWritable(key, typeConverter, keySize);
                Holder valueSize = new Holder();
                Writable valueWritable = HdfsFileType.getWritable(value, typeConverter, valueSize);
                ((MapFile.Writer)hdfsostr.getOut()).append((WritableComparable)keyWritable, valueWritable);
                return (Integer)keySize.value + (Integer)valueSize.value;
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public long next(HdfsInputStream hdfsistr, Holder<Object> key, Holder<Object> value) {
            try {
                MapFile.Reader reader = (MapFile.Reader)hdfsistr.getIn();
                Holder keySize = new Holder();
                WritableComparable keyWritable = (WritableComparable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)new Configuration());
                Holder valueSize = new Holder();
                Writable valueWritable = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)new Configuration());
                if (reader.next(keyWritable, valueWritable)) {
                    key.value = HdfsFileType.getObject((Writable)keyWritable, keySize);
                    value.value = HdfsFileType.getObject(valueWritable, valueSize);
                    return (Integer)keySize.value + (Integer)valueSize.value;
                }
                return 0L;
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Closeable createOutputStream(String hdfsPath, HdfsConfiguration configuration) {
            try {
                HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                Class<? extends WritableComparable> keyWritableClass = configuration.getKeyType().getWritableClass();
                Class<? extends WritableComparable> valueWritableClass = configuration.getValueType().getWritableClass();
                MapFile.Writer rout = new MapFile.Writer(hdfsInfo.getConf(), hdfsInfo.getFileSystem(), hdfsPath, keyWritableClass, valueWritableClass, configuration.getCompressionType(), configuration.getCompressionCodec().getCodec(), new Progressable(){

                    public void progress() {
                    }
                });
                return rout;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Closeable createInputStream(String hdfsPath, HdfsConfiguration configuration) {
            try {
                HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                MapFile.Reader rin = new MapFile.Reader(hdfsInfo.getFileSystem(), hdfsPath, hdfsInfo.getConf());
                return rin;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
    }
    ,
    BLOOMMAP_FILE{

        @Override
        public long append(HdfsOutputStream hdfsostr, Object key, Object value, TypeConverter typeConverter) {
            try {
                Holder keySize = new Holder();
                Writable keyWritable = HdfsFileType.getWritable(key, typeConverter, keySize);
                Holder valueSize = new Holder();
                Writable valueWritable = HdfsFileType.getWritable(value, typeConverter, valueSize);
                ((BloomMapFile.Writer)hdfsostr.getOut()).append((WritableComparable)keyWritable, valueWritable);
                return (Integer)keySize.value + (Integer)valueSize.value;
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public long next(HdfsInputStream hdfsistr, Holder<Object> key, Holder<Object> value) {
            try {
                BloomMapFile.Reader reader = (BloomMapFile.Reader)hdfsistr.getIn();
                Holder keySize = new Holder();
                WritableComparable keyWritable = (WritableComparable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)new Configuration());
                Holder valueSize = new Holder();
                Writable valueWritable = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)new Configuration());
                if (reader.next(keyWritable, valueWritable)) {
                    key.value = HdfsFileType.getObject((Writable)keyWritable, keySize);
                    value.value = HdfsFileType.getObject(valueWritable, valueSize);
                    return (Integer)keySize.value + (Integer)valueSize.value;
                }
                return 0L;
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Closeable createOutputStream(String hdfsPath, HdfsConfiguration configuration) {
            try {
                HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                Class<? extends WritableComparable> keyWritableClass = configuration.getKeyType().getWritableClass();
                Class<? extends WritableComparable> valueWritableClass = configuration.getValueType().getWritableClass();
                BloomMapFile.Writer rout = new BloomMapFile.Writer(hdfsInfo.getConf(), hdfsInfo.getFileSystem(), hdfsPath, keyWritableClass, valueWritableClass, configuration.getCompressionType(), configuration.getCompressionCodec().getCodec(), new Progressable(){

                    public void progress() {
                    }
                });
                return rout;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Closeable createInputStream(String hdfsPath, HdfsConfiguration configuration) {
            try {
                HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                BloomMapFile.Reader rin = new BloomMapFile.Reader(hdfsInfo.getFileSystem(), hdfsPath, hdfsInfo.getConf());
                return rin;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
    }
    ,
    ARRAY_FILE{

        @Override
        public long append(HdfsOutputStream hdfsostr, Object key, Object value, TypeConverter typeConverter) {
            try {
                Holder valueSize = new Holder();
                Writable valueWritable = HdfsFileType.getWritable(value, typeConverter, valueSize);
                ((ArrayFile.Writer)hdfsostr.getOut()).append(valueWritable);
                return ((Integer)valueSize.value).intValue();
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public long next(HdfsInputStream hdfsistr, Holder<Object> key, Holder<Object> value) {
            try {
                ArrayFile.Reader reader = (ArrayFile.Reader)hdfsistr.getIn();
                Holder valueSize = new Holder();
                Writable valueWritable = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)new Configuration());
                if (reader.next(valueWritable) != null) {
                    value.value = HdfsFileType.getObject(valueWritable, valueSize);
                    return ((Integer)valueSize.value).intValue();
                }
                return 0L;
            }
            catch (Exception ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Closeable createOutputStream(String hdfsPath, HdfsConfiguration configuration) {
            try {
                HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                Class<? extends WritableComparable> valueWritableClass = configuration.getValueType().getWritableClass();
                ArrayFile.Writer rout = new ArrayFile.Writer(hdfsInfo.getConf(), hdfsInfo.getFileSystem(), hdfsPath, valueWritableClass, configuration.getCompressionType(), new Progressable(){

                    public void progress() {
                    }
                });
                return rout;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }

        @Override
        public Closeable createInputStream(String hdfsPath, HdfsConfiguration configuration) {
            try {
                HdfsInfo hdfsInfo = new HdfsInfo(hdfsPath);
                ArrayFile.Reader rin = new ArrayFile.Reader(hdfsInfo.getFileSystem(), hdfsPath, hdfsInfo.getConf());
                return rin;
            }
            catch (IOException ex) {
                throw new RuntimeCamelException((Throwable)ex);
            }
        }
    };


    private static Writable getWritable(Object obj, TypeConverter typeConverter, Holder<Integer> size) {
        Class<?> objCls = obj == null ? null : obj.getClass();
        HdfsWritableFactories.HdfsWritableFactory objWritableFactory = (HdfsWritableFactories.HdfsWritableFactory)WritableCache.writables.get(objCls);
        if (objWritableFactory == null) {
            objWritableFactory = new HdfsWritableFactories.HdfsObjectWritableFactory();
        }
        return objWritableFactory.create(obj, typeConverter, size);
    }

    private static Object getObject(Writable writable, Holder<Integer> size) {
        Class writableClass = NullWritable.class;
        if (writable != null) {
            writableClass = writable.getClass();
        }
        HdfsWritableFactories.HdfsWritableFactory writableObjectFactory = (HdfsWritableFactories.HdfsWritableFactory)WritableCache.readables.get(writableClass);
        return writableObjectFactory.read(writable, size);
    }

    public abstract long append(HdfsOutputStream var1, Object var2, Object var3, TypeConverter var4);

    public abstract long next(HdfsInputStream var1, Holder<Object> var2, Holder<Object> var3);

    public abstract Closeable createOutputStream(String var1, HdfsConfiguration var2);

    public abstract Closeable createInputStream(String var1, HdfsConfiguration var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long copyBytes(InputStream in, OutputStream out, int buffSize, boolean close) throws IOException {
        long numBytes = 0L;
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : null;
        byte[] buf = new byte[buffSize];
        try {
            int bytesRead = in.read(buf);
            while (bytesRead >= 0) {
                out.write(buf, 0, bytesRead);
                numBytes += (long)bytesRead;
                if (ps != null && ps.checkError()) {
                    throw new IOException("Unable to write to output stream.");
                }
                bytesRead = in.read(buf);
            }
            if (!close) return numBytes;
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            IOHelper.close((Closeable[])new Closeable[]{out, in});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{out, in});
        return numBytes;
    }

    private static final class WritableCache {
        private static Map<Class, HdfsWritableFactories.HdfsWritableFactory> writables = new HashMap<Class, HdfsWritableFactories.HdfsWritableFactory>();
        private static Map<Class, HdfsWritableFactories.HdfsWritableFactory> readables = new HashMap<Class, HdfsWritableFactories.HdfsWritableFactory>();

        private WritableCache() {
        }

        static {
            writables.put(Boolean.class, new HdfsWritableFactories.HdfsBooleanWritableFactory());
            writables.put(Byte.class, new HdfsWritableFactories.HdfsByteWritableFactory());
            writables.put(ByteBuffer.class, new HdfsWritableFactories.HdfsBytesWritableFactory());
            writables.put(Double.class, new HdfsWritableFactories.HdfsDoubleWritableFactory());
            writables.put(Float.class, new HdfsWritableFactories.HdfsFloatWritableFactory());
            writables.put(Integer.class, new HdfsWritableFactories.HdfsIntWritableFactory());
            writables.put(Long.class, new HdfsWritableFactories.HdfsLongWritableFactory());
            writables.put(String.class, new HdfsWritableFactories.HdfsTextWritableFactory());
            writables.put(null, new HdfsWritableFactories.HdfsNullWritableFactory());
            readables.put(BooleanWritable.class, new HdfsWritableFactories.HdfsBooleanWritableFactory());
            readables.put(ByteWritable.class, new HdfsWritableFactories.HdfsByteWritableFactory());
            readables.put(BytesWritable.class, new HdfsWritableFactories.HdfsBytesWritableFactory());
            readables.put(DoubleWritable.class, new HdfsWritableFactories.HdfsDoubleWritableFactory());
            readables.put(FloatWritable.class, new HdfsWritableFactories.HdfsFloatWritableFactory());
            readables.put(IntWritable.class, new HdfsWritableFactories.HdfsIntWritableFactory());
            readables.put(LongWritable.class, new HdfsWritableFactories.HdfsLongWritableFactory());
            readables.put(Text.class, new HdfsWritableFactories.HdfsTextWritableFactory());
            readables.put(NullWritable.class, new HdfsWritableFactories.HdfsNullWritableFactory());
        }
    }
}

