/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.krati;

import krati.store.DataStore;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.krati.KratiEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KratiProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(KratiProducer.class);
    protected KratiEndpoint endpoint;
    protected DataStore<Object, Object> dataStore;

    public KratiProducer(KratiEndpoint endpoint, DataStore<Object, Object> dataStore) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.dataStore = dataStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String operation = this.getOperation(exchange);
        Object key = this.getKey(exchange);
        LOG.trace("Processing {} operation on '[{}]'", (Object)operation, (Object)exchange);
        if ("CamelKratiGet".equals(operation) && key != null) {
            exchange.getOut().setBody(this.dataStore.get(key));
        } else if ("CamelKratiDelete".equals(operation) && key != null) {
            boolean status;
            DataStore<Object, Object> dataStore = this.dataStore;
            synchronized (dataStore) {
                status = this.dataStore.delete(key);
                this.dataStore.persist();
            }
            if (status) {
                exchange.getOut().setHeader("CamelKratiOperationStatus", (Object)"CamelKratiOperationSuccess");
            } else {
                exchange.getOut().setHeader("CamelKratiOperationStatus", (Object)"CamelKratiOperationFailure");
            }
        } else if ("CamelKratiDeleteAll".equals(operation)) {
            try {
                this.dataStore.clear();
                exchange.getOut().setHeader("CamelKratiOperationStatus", (Object)"CamelKratiOperationSuccess");
            }
            catch (Exception e) {
                LOG.warn("Error clearing all entries from store", (Throwable)e);
                exchange.getOut().setHeader("CamelKratiOperationStatus", (Object)"CamelKratiOperationFailure");
            }
        } else {
            Object value = this.getValue(exchange);
            String string = this.endpoint.getPath().intern();
            synchronized (string) {
                this.dataStore.put(key, value);
            }
        }
    }

    public String getOperation(Exchange exchange) {
        String operation = ((KratiEndpoint)this.getEndpoint()).getOperation();
        if (exchange.getIn().getHeader("CamelKratiOperation") != null) {
            operation = (String)exchange.getIn().getHeader("CamelKratiOperation");
        }
        return operation;
    }

    public Object getKey(Exchange exchange) {
        Object key = ((KratiEndpoint)this.getEndpoint()).getKey();
        if (exchange.getIn().getHeader("CamelKratiKey") != null) {
            key = exchange.getIn().getHeader("CamelKratiKey");
        }
        return key;
    }

    public Object getValue(Exchange exchange) {
        Object value = ((KratiEndpoint)this.getEndpoint()).getValue();
        if (exchange.getIn().getHeader("CamelKratiValue") != null) {
            value = exchange.getIn().getHeader("CamelKratiValue");
        }
        if (exchange.getIn().getBody() != null) {
            value = exchange.getIn().getBody();
        }
        return value;
    }
}

