/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.krati.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import krati.io.SerializationException;
import krati.io.Serializer;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KratiDefaultSerializer<T extends Serializable>
implements Serializer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(KratiDefaultSerializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(T object) throws SerializationException {
        byte[] result = null;
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            result = baos.toByteArray();
        }
        catch (IOException e) {
            try {
                LOG.warn("Error while serializing object. Null will be used.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOHelper.close((Closeable[])new Closeable[]{oos, baos});
                throw throwable;
            }
            IOHelper.close((Closeable[])new Closeable[]{oos, baos});
        }
        IOHelper.close((Closeable[])new Closeable[]{oos, baos});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public T deserialize(byte[] binary) throws SerializationException {
        Serializable result = null;
        ObjectInputStream ois = null;
        if (binary == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(binary);
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            ois = new ObjectInputStream(bais){

                @Override
                public Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    try {
                        return classLoader.loadClass(desc.getName());
                    }
                    catch (Exception exception) {
                        return super.resolveClass(desc);
                    }
                }
            };
            result = (Serializable)ois.readObject();
        }
        catch (IOException e) {
            LOG.warn("Error while deserializing object. Null will be used.", (Throwable)e);
            IOHelper.close((Closeable[])new Closeable[]{ois, bais});
        }
        catch (ClassNotFoundException e2) {
            LOG.warn("Could not find class while deserializing object. Null will be used.", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOHelper.close((Closeable[])new Closeable[]{ois, bais});
                    throw throwable;
                }
            }
            IOHelper.close((Closeable[])new Closeable[]{ois, bais});
        }
        IOHelper.close((Closeable[])new Closeable[]{ois, bais});
        return (T)result;
    }
}

