/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.solr.SolrComponent;
import org.apache.camel.component.solr.SolrProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.impl.StreamingUpdateSolrServer;

public class SolrEndpoint
extends DefaultEndpoint {
    private CommonsHttpSolrServer solrServer;
    private CommonsHttpSolrServer streamingSolrServer;
    private String requestHandler;
    private int streamingThreadCount;
    private int streamingQueueSize;

    public SolrEndpoint(String endpointUri, SolrComponent component, String address, Map<String, Object> parameters) throws Exception {
        super(endpointUri, (Component)component);
        this.solrServer = new CommonsHttpSolrServer("http://" + address);
        this.streamingQueueSize = SolrEndpoint.getIntFromString((String)parameters.get("streamingQueueSize"), 10);
        this.streamingThreadCount = SolrEndpoint.getIntFromString((String)parameters.get("streamingThreadCount"), 2);
        this.streamingSolrServer = new StreamingUpdateSolrServer("http://" + address, this.streamingQueueSize, this.streamingThreadCount);
    }

    public static int getIntFromString(String value, int defaultValue) {
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public Producer createProducer() throws Exception {
        return new SolrProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for Solr endpoint.");
    }

    public boolean isSingleton() {
        return true;
    }

    public CommonsHttpSolrServer getSolrServer() {
        return this.solrServer;
    }

    public CommonsHttpSolrServer getStreamingSolrServer() {
        return this.streamingSolrServer;
    }

    public void setStreamingSolrServer(CommonsHttpSolrServer streamingSolrServer) {
        this.streamingSolrServer = streamingSolrServer;
    }

    public void setMaxRetries(int maxRetries) {
        this.solrServer.setMaxRetries(maxRetries);
        this.streamingSolrServer.setMaxRetries(maxRetries);
    }

    public void setSoTimeout(int soTimeout) {
        this.solrServer.setSoTimeout(soTimeout);
        this.streamingSolrServer.setSoTimeout(soTimeout);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.solrServer.setConnectionTimeout(connectionTimeout);
        this.streamingSolrServer.setConnectionTimeout(connectionTimeout);
    }

    public void setDefaultMaxConnectionsPerHost(int defaultMaxConnectionsPerHost) {
        this.solrServer.setDefaultMaxConnectionsPerHost(defaultMaxConnectionsPerHost);
        this.streamingSolrServer.setDefaultMaxConnectionsPerHost(defaultMaxConnectionsPerHost);
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.solrServer.setMaxTotalConnections(maxTotalConnections);
        this.streamingSolrServer.setMaxTotalConnections(maxTotalConnections);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.solrServer.setFollowRedirects(followRedirects);
        this.streamingSolrServer.setFollowRedirects(followRedirects);
    }

    public void setAllowCompression(boolean allowCompression) {
        this.solrServer.setAllowCompression(allowCompression);
        this.streamingSolrServer.setAllowCompression(allowCompression);
    }

    public void setRequestHandler(String requestHandler) {
        this.requestHandler = requestHandler;
    }

    public String getRequestHandler() {
        return this.requestHandler;
    }

    public int getStreamingThreadCount() {
        return this.streamingThreadCount;
    }

    public void setStreamingThreadCount(int streamingThreadCount) {
        this.streamingThreadCount = streamingThreadCount;
    }

    public int getStreamingQueueSize() {
        return this.streamingQueueSize;
    }

    public void setStreamingQueueSize(int streamingQueueSize) {
        this.streamingQueueSize = streamingQueueSize;
    }
}

