/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Throws;

public class Fingerprints {
    private static final String DIGEST_SHA1 = "SHA-1";

    private static MessageDigest createMessageDigest() throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(DIGEST_SHA1);
        return digest;
    }

    public static byte[] internal_sha1v2(File file) {
        Checks.ensureIsNotNull(file);
        Checks.ensureExists(file);
        Checks.ensureIsFile(file);
        try {
            MessageDigest digest = Fingerprints.createMessageDigest();
            return Files.getDigest((File)file, (MessageDigest)digest);
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException(e);
        }
    }

    public static String sha1(File file) {
        byte[] sha1 = Fingerprints.internal_sha1v2(file);
        return Fingerprints.toHexString(sha1);
    }

    private static String toString(MessageDigest digest) {
        byte[] res = digest.digest();
        return Fingerprints.toHexString(res);
    }

    public static String sha1(String message) {
        Checks.ensureIsNotNull(message);
        try {
            MessageDigest digest = Fingerprints.createMessageDigest();
            digest.update(message.getBytes());
            return Fingerprints.toString(digest);
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException(e);
        }
    }

    public static String sha1(InputStream stream) {
        Checks.ensureIsNotNull(stream);
        try {
            MessageDigest digest = Fingerprints.createMessageDigest();
            StreamInputSupplier supplier = new StreamInputSupplier(stream);
            byte[] sha1 = ByteStreams.getDigest((InputSupplier)supplier, (MessageDigest)digest);
            String string = Fingerprints.toHexString(sha1);
            return string;
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException(e);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    private static String toHexString(byte[] hash) {
        Checks.ensureIsNotNull(hash);
        Formatter formatter = new Formatter();
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        return formatter.toString();
    }

    private Fingerprints() {
    }

    private static final class StreamInputSupplier
    implements InputSupplier<InputStream> {
        private final InputStream stream;

        private StreamInputSupplier(InputStream stream) {
            this.stream = stream;
        }

        public InputStream getInput() throws IOException {
            return this.stream;
        }
    }
}

