/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.recommenders.utils.parser.OsgiVersionParser;

public class Version
implements Comparable<Version> {
    public static final Version ZERO = Version.create(0, 0, 0);
    public static final Version UNKNOWN = Version.create(-1, -1, -1);
    public static final Version LATEST = Version.create(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public int major;
    public int minor;
    public int micro;
    public String qualifier = "";

    public static Version create(int major, int minor, int micro, String qualifier) {
        Version res = new Version(major, minor, micro, qualifier);
        return res;
    }

    public static Version create(int major, int minor, int micro) {
        return Version.create(major, minor, micro, "");
    }

    public static Version create(int major, int minor) {
        return Version.create(major, minor, 0, "");
    }

    public static Version valueOf(String version) {
        return new OsgiVersionParser().parse(version);
    }

    protected Version() {
    }

    protected Version(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    @Override
    public int compareTo(Version v) {
        if (this.major != v.major) {
            return new Integer(this.major).compareTo(v.major);
        }
        if (this.minor != v.minor) {
            return new Integer(this.minor).compareTo(v.minor);
        }
        if (this.micro != v.micro) {
            return new Integer(this.micro).compareTo(v.micro);
        }
        return this.qualifier.compareTo(v.qualifier);
    }

    public String toString() {
        String res = this.qualifier.isEmpty() ? String.format("%d.%d.%d", this.major, this.minor, this.micro) : String.format("%d.%d.%d.%s", this.major, this.minor, this.micro, this.qualifier);
        return res;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean isUnknown() {
        return this.equals(UNKNOWN);
    }
}

