/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.osgi.util.NLS;

public class ProjectImportConfiguration {
    private static final String GROUP_ID = "\\[groupId\\]";
    private static final String ARTIFACT_ID = "\\[artifactId\\]";
    private static final String VERSION = "\\[version\\]";
    private ResolverConfiguration resolverConfiguration;
    private String projectNameTemplate = "";

    public ProjectImportConfiguration(ResolverConfiguration resolverConfiguration) {
        this.resolverConfiguration = resolverConfiguration;
    }

    public ProjectImportConfiguration() {
        this(new ResolverConfiguration());
    }

    public ResolverConfiguration getResolverConfiguration() {
        return this.resolverConfiguration;
    }

    public void setProjectNameTemplate(String projectNameTemplate) {
        this.projectNameTemplate = projectNameTemplate;
    }

    public String getProjectNameTemplate() {
        return this.projectNameTemplate;
    }

    public String getProjectName(Model model) {
        String version;
        if (this.projectNameTemplate.length() == 0) {
            return model.getArtifactId();
        }
        String artifactId = model.getArtifactId();
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        if ((version = model.getVersion()) == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return this.projectNameTemplate.replaceAll(GROUP_ID, groupId).replaceAll(ARTIFACT_ID, artifactId).replaceAll(VERSION, version == null ? "" : version);
    }

    public IProject getProject(IWorkspaceRoot root, Model model) {
        return root.getProject(this.getProjectName(model));
    }

    public IStatus validateProjectName(Model model) {
        String projectName = this.getProjectName(model);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(projectName, 4);
        if (!nameStatus.isOK()) {
            return nameStatus;
        }
        if (workspace.getRoot().getProject(projectName).exists()) {
            return new Status(4, "org.eclipse.m2e.core", 0, NLS.bind((String)Messages.importProjectExists, (Object)projectName), null);
        }
        return Status.OK_STATUS;
    }
}

