/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.builds.ui.editor.AbstractBuildEditorPart;
import org.eclipse.mylyn.internal.builds.ui.editor.ActionPart;
import org.eclipse.mylyn.internal.builds.ui.editor.ArtifactsPart;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorPage;
import org.eclipse.mylyn.internal.builds.ui.editor.ChangesPart;
import org.eclipse.mylyn.internal.builds.ui.editor.HeaderPart;
import org.eclipse.mylyn.internal.builds.ui.editor.SummaryPart;
import org.eclipse.mylyn.internal.builds.ui.editor.TestResultPart;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class BuildDetailsPage
extends BuildEditorPage {
    public static final String BUILD_EDITOR_PAGE_ID = "org.eclipse.mylyn.build.ui.editor.DetailsPage";
    private Form form;
    private List<AbstractBuildEditorPart> parts;
    private FormToolkit toolkit;

    public BuildDetailsPage(FormEditor editor, String title) {
        super(editor, BUILD_EDITOR_PAGE_ID, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        boolean fillBottomPart;
        super.createFormContent(managedForm);
        this.form = managedForm.getForm().getForm();
        this.toolkit = managedForm.getToolkit();
        Composite body = this.form.getBody();
        body.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        body.setBackgroundMode(2);
        boolean bl = fillBottomPart = this.parts.size() > 0 && this.parts.get((int)(this.parts.size() - 1)).span == 2 && this.parts.get((int)(this.parts.size() - 1)).expandVertically;
        if (this.parts.size() > 1) {
            Composite bodyTop = new Composite(body, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)bodyTop);
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = 2;
            bodyTop.setLayout((Layout)layout);
            for (AbstractBuildEditorPart part : this.parts.subList(0, fillBottomPart ? this.parts.size() - 1 : this.parts.size())) {
                this.createPart(bodyTop, part);
                TableWrapData data = new TableWrapData();
                data.colspan = part.getSpan();
                data.align = 128;
                data.valign = 128;
                data.grabHorizontal = true;
                data.grabVertical = part.getExpandVertically();
                part.getControl().setLayoutData((Object)data);
            }
        }
        if (fillBottomPart) {
            AbstractBuildEditorPart part;
            Composite bodyBottom = new Composite(body, 0);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)bodyBottom);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginHeight = 5;
            fillLayout.marginWidth = 5;
            bodyBottom.setLayout((Layout)fillLayout);
            part = this.parts.get(this.parts.size() - 1);
            this.createPart(bodyBottom, part);
        }
    }

    private void createPart(Composite body, AbstractBuildEditorPart part) {
        part.initialize(this);
        this.getManagedForm().addPart((IFormPart)part);
        Control control = part.createControl(body, this.toolkit);
        part.setControl(control);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.parts = new ArrayList<AbstractBuildEditorPart>();
        this.parts.add(new HeaderPart());
        this.parts.add(new SummaryPart());
        this.parts.add(new ActionPart());
        this.parts.add(new TestResultPart());
        this.parts.add(new ArtifactsPart());
        this.parts.add(new ChangesPart());
    }

    public void setFocus() {
        this.getManagedForm().getForm().getForm().getBody().setFocus();
    }
}

