/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;

class GitMoveDeleteHook
implements IMoveDeleteHook {
    private static final boolean I_AM_DONE = true;
    private static final boolean FINISH_FOR_ME = false;
    private final GitProjectData data;

    GitMoveDeleteHook(GitProjectData d) {
        Assert.isNotNull((Object)d);
        this.data = d;
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        boolean force;
        if (file.isLinked()) {
            return false;
        }
        boolean bl = force = (updateFlags & 1) == 1;
        if (!force && !tree.isSynchronized((IResource)file, 0)) {
            return false;
        }
        RepositoryMapping map = RepositoryMapping.getMapping((IResource)file);
        if (map == null) {
            return false;
        }
        String repoRelativePath = map.getRepoRelativePath((IResource)file);
        IndexDiffCache indexDiffCache = Activator.getDefault().getIndexDiffCache();
        IndexDiffCacheEntry indexDiffCacheEntry = indexDiffCache.getIndexDiffCacheEntry(map.getRepository());
        IndexDiffData indexDiff = indexDiffCacheEntry.getIndexDiff();
        if (indexDiff != null) {
            if (indexDiff.getUntracked().contains(repoRelativePath)) {
                return false;
            }
            if (indexDiff.getIgnoredNotInIndex().contains(repoRelativePath)) {
                return false;
            }
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isDerived()) {
            return false;
        }
        DirCache dirc = null;
        try {
            dirc = map.getRepository().lockDirCache();
            int first = dirc.findEntry(repoRelativePath);
            if (first < 0) {
                dirc.unlock();
                return false;
            }
            try {
                int next;
                DirCacheBuilder edit = dirc.builder();
                if (first > 0) {
                    edit.keep(0, first);
                }
                if ((next = dirc.nextEntry(first)) < dirc.getEntryCount()) {
                    edit.keep(next, dirc.getEntryCount() - next);
                }
                if (!edit.commit()) {
                    tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, null));
                }
                tree.standardDeleteFile(file, updateFlags, monitor);
            }
            catch (IOException e) {
                tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, (Throwable)e));
            }
        }
        finally {
            if (dirc != null) {
                dirc.unlock();
            }
        }
        return true;
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        if (this.data.isProtected((IResource)folder)) {
            return this.cannotModifyRepository(tree);
        }
        return false;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        return false;
    }

    public boolean moveFile(IResourceTree tree, IFile srcf, IFile dstf, int updateFlags, IProgressMonitor monitor) {
        boolean force;
        boolean bl = force = (updateFlags & 1) == 1;
        if (!force && !tree.isSynchronized((IResource)srcf, 0)) {
            return false;
        }
        RepositoryMapping srcm = RepositoryMapping.getMapping((IResource)srcf);
        if (srcm == null) {
            return false;
        }
        RepositoryMapping dstm = RepositoryMapping.getMapping((IResource)dstf);
        DirCache sCache = null;
        try {
            sCache = srcm.getRepository().lockDirCache();
            String sPath = srcm.getRepoRelativePath((IResource)srcf);
            final DirCacheEntry sEnt = sCache.getEntry(sPath);
            if (sEnt == null) {
                return false;
            }
            if (!sEnt.isMerged()) {
                tree.failed((IStatus)new Status(2, Activator.getPluginId(), CoreText.MoveDeleteHook_unmergedFileError));
                return true;
            }
            try {
                DirCacheEditor sEdit = sCache.editor();
                sEdit.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(sEnt));
                if (dstm != null && dstm.getRepository() == srcm.getRepository()) {
                    String dPath = srcm.getRepoRelativePath((IResource)dstf);
                    sEdit.add(new DirCacheEditor.PathEdit(dPath){

                        public void apply(DirCacheEntry dEnt) {
                            dEnt.copyMetaData(sEnt);
                        }
                    });
                }
                if (!sEdit.commit()) {
                    tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, null));
                }
                tree.standardMoveFile(srcf, dstf, updateFlags, monitor);
            }
            catch (IOException e) {
                tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, (Throwable)e));
            }
        }
        finally {
            if (sCache != null) {
                sCache.unlock();
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveFolder(IResourceTree tree, IFolder srcf, IFolder dstf, int updateFlags, IProgressMonitor monitor) {
        boolean force;
        boolean bl = force = (updateFlags & 1) == 1;
        if (!force && !tree.isSynchronized((IResource)srcf, 0)) {
            return false;
        }
        RepositoryMapping srcm = RepositoryMapping.getMapping((IResource)srcf);
        if (srcm == null) {
            return false;
        }
        RepositoryMapping dstm = RepositoryMapping.getMapping((IResource)dstf);
        try {
            String sPath = srcm.getRepoRelativePath((IResource)srcf);
            if (dstm != null && dstm.getRepository() == srcm.getRepository()) {
                String dPath = String.valueOf(srcm.getRepoRelativePath((IResource)dstf)) + "/";
                MoveResult result = this.moveIndexContent(dPath, srcm, sPath);
                switch (result) {
                    case SUCCESS: {
                        break;
                    }
                    case FAILED: {
                        tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, null));
                        return true;
                    }
                    case UNTRACKED: {
                        return false;
                    }
                    case UNMERGED: {
                        tree.failed((IStatus)new Status(2, Activator.getPluginId(), CoreText.MoveDeleteHook_unmergedFileInFolderError));
                        return true;
                    }
                }
            }
            tree.standardMoveFolder(srcf, dstf, updateFlags, monitor);
            return true;
        }
        catch (IOException e) {
            tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, (Throwable)e));
        }
        return true;
    }

    private void mapProject(IProject source, IProjectDescription description, IProgressMonitor monitor, IPath gitDir) throws CoreException, TeamException {
        IProject destination = source.getWorkspace().getRoot().getProject(description.getName());
        GitProjectData projectData = new GitProjectData(destination);
        RepositoryMapping repositoryMapping = new RepositoryMapping((IContainer)destination, gitDir.toFile());
        projectData.setRepositoryMappings(Arrays.asList(repositoryMapping));
        projectData.store();
        GitProjectData.add(destination, projectData);
        RepositoryProvider.map((IProject)destination, (String)GitProvider.class.getName());
        destination.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
    }

    private boolean unmapProject(IResourceTree tree, IProject source) {
        try {
            RepositoryProvider.unmap((IProject)source);
        }
        catch (TeamException e) {
            tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, (Throwable)e));
            return true;
        }
        return false;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        RepositoryMapping srcm = RepositoryMapping.getMapping((IResource)source);
        if (srcm == null) {
            return false;
        }
        IPath newLocation = null;
        newLocation = description.getLocationURI() != null ? URIUtil.toPath((URI)description.getLocationURI()) : source.getWorkspace().getRoot().getLocation().append(description.getName());
        IPath sourceLocation = source.getLocation();
        if (sourceLocation.isPrefixOf(newLocation) && sourceLocation.segmentCount() != newLocation.segmentCount() && !"true".equals(System.getProperty("egit.assume_307140_fixed"))) {
            tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, "Cannot move project. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=307140 (not resolved in 3.7)", null));
            return true;
        }
        File newLocationFile = newLocation.toFile();
        Path workTree = new Path(srcm.getRepository().getWorkTree().getAbsolutePath());
        int matchingFirstSegments = workTree.matchingFirstSegments(newLocation);
        if (matchingFirstSegments == workTree.segmentCount()) {
            return this.moveProjectHelperMoveOnlyProject(tree, source, description, updateFlags, monitor, srcm, newLocationFile);
        }
        int dstAboveSrcRepo = newLocation.matchingFirstSegments(RepositoryMapping.getMapping((IResource)source).getGitDirAbsolutePath());
        int srcAboveSrcRepo = sourceLocation.matchingFirstSegments(RepositoryMapping.getMapping((IResource)source).getGitDirAbsolutePath());
        if (dstAboveSrcRepo > 0 && srcAboveSrcRepo > 0) {
            return this.moveProjectHelperMoveRepo(tree, source, description, updateFlags, monitor, srcm, newLocation, sourceLocation);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean moveProjectHelperMoveOnlyProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor, RepositoryMapping srcm, File newLocationFile) {
        String sPath = srcm.getRepoRelativePath((IResource)source);
        String absoluteWorkTreePath = srcm.getRepository().getWorkTree().getAbsolutePath();
        String newLocationAbsolutePath = newLocationFile.getAbsolutePath();
        String dPath = newLocationAbsolutePath.equals(absoluteWorkTreePath) ? "" : new Path(String.valueOf(newLocationAbsolutePath.substring(absoluteWorkTreePath.length() + 1)) + "/").toPortableString();
        try {
            IPath gitDir = srcm.getGitDirAbsolutePath();
            if (this.unmapProject(tree, source)) {
                return true;
            }
            monitor.worked(100);
            MoveResult result = this.moveIndexContent(dPath, srcm, sPath);
            switch (result) {
                case SUCCESS: {
                    break;
                }
                case FAILED: {
                    tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, null));
                    break;
                }
                case UNTRACKED: {
                    return false;
                }
                case UNMERGED: {
                    tree.failed((IStatus)new Status(2, Activator.getPluginId(), CoreText.MoveDeleteHook_unmergedFileInFolderError));
                    return true;
                }
            }
            tree.standardMoveProject(source, description, updateFlags, monitor);
            this.mapProject(source.getWorkspace().getRoot().getProject(description.getName()), description, monitor, gitDir);
            return true;
        }
        catch (IOException e) {
            tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, (Throwable)e));
            return true;
        }
        catch (CoreException e) {
            tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, (Throwable)e));
        }
        return true;
    }

    private boolean moveProjectHelperMoveRepo(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor, RepositoryMapping srcm, IPath newLocation, IPath sourceLocation) {
        IPath gitDir = srcm.getGitDirAbsolutePath();
        if (this.unmapProject(tree, source)) {
            return true;
        }
        monitor.worked(100);
        IPath relativeGitDir = gitDir.makeRelativeTo(sourceLocation);
        tree.standardMoveProject(source, description, updateFlags, monitor);
        IPath newGitDir = newLocation.append(relativeGitDir);
        try {
            this.mapProject(source, description, monitor, newGitDir);
        }
        catch (CoreException e) {
            tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_operationError, (Throwable)e));
        }
        return true;
    }

    private MoveResult moveIndexContent(String dPath, RepositoryMapping srcm, String sPath) throws IOException {
        DirCache sCache = srcm.getRepository().lockDirCache();
        try {
            DirCacheEntry[] sEnt = sCache.getEntriesWithin(sPath);
            if (sEnt.length == 0) {
                sCache.unlock();
                MoveResult moveResult = MoveResult.UNTRACKED;
                return moveResult;
            }
            DirCacheEditor sEdit = sCache.editor();
            sEdit.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(sPath));
            int sPathLen = sPath.length() == 0 ? sPath.length() : sPath.length() + 1;
            DirCacheEntry[] dirCacheEntryArray = sEnt;
            int n = sEnt.length;
            int n2 = 0;
            while (n2 < n) {
                final DirCacheEntry se = dirCacheEntryArray[n2];
                if (!se.isMerged()) {
                    MoveResult moveResult = MoveResult.UNMERGED;
                    return moveResult;
                }
                String p = se.getPathString().substring(sPathLen);
                sEdit.add(new DirCacheEditor.PathEdit(String.valueOf(dPath) + p){

                    public void apply(DirCacheEntry dEnt) {
                        dEnt.copyMetaData(se);
                    }
                });
                ++n2;
            }
            if (sEdit.commit()) {
                MoveResult moveResult = MoveResult.SUCCESS;
                return moveResult;
            }
            MoveResult moveResult = MoveResult.FAILED;
            return moveResult;
        }
        finally {
            if (sCache != null) {
                sCache.unlock();
            }
        }
    }

    private boolean cannotModifyRepository(IResourceTree tree) {
        tree.failed((IStatus)new Status(4, Activator.getPluginId(), 0, CoreText.MoveDeleteHook_cannotModifyFolder, null));
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MoveResult {
        SUCCESS,
        FAILED,
        UNTRACKED,
        UNMERGED;

    }
}

