/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.SystemReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryFinder {
    private final IProject proj;
    private final Collection<RepositoryMapping> results = new ArrayList<RepositoryMapping>();
    private final Set<File> gitdirs = new HashSet<File>();
    private Set<File> ceilingDirectories = new HashSet<File>();

    public RepositoryFinder(IProject p) {
        this.proj = p;
        String ceilingDirectoriesVar = SystemReader.getInstance().getenv("GIT_CEILING_DIRECTORIES");
        if (ceilingDirectoriesVar != null) {
            String[] stringArray = ceilingDirectoriesVar.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                this.ceilingDirectories.add(new File(path));
                ++n2;
            }
        }
    }

    public Collection<RepositoryMapping> find(IProgressMonitor m) throws CoreException {
        return this.find(m, false);
    }

    public Collection<RepositoryMapping> find(IProgressMonitor m, boolean searchLinkedFolders) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        this.find((IProgressMonitor)monitor, (IContainer)this.proj, searchLinkedFolders);
        return this.results;
    }

    private void find(IProgressMonitor m, IContainer c, boolean searchLinkedFolders) throws CoreException {
        if (!searchLinkedFolders && c.isLinked()) {
            return;
        }
        IPath loc = c.getLocation();
        m.beginTask("", 101);
        m.subTask(CoreText.RepositoryFinder_finding);
        try {
            if (loc != null) {
                File fsLoc = loc.toFile();
                assert (fsLoc.isAbsolute());
                if (c instanceof IProject) {
                    this.findInDirectoryAndParents(c, fsLoc);
                } else {
                    this.findInDirectory(c, fsLoc);
                }
                m.worked(1);
                IResource[] children = c.members();
                if (children != null && children.length > 0) {
                    int scale = 100 / children.length;
                    int k = 0;
                    while (k < children.length) {
                        IResource o = children[k];
                        if (o instanceof IContainer && !o.getName().equals(".git")) {
                            this.find((IProgressMonitor)new SubProgressMonitor(m, scale), (IContainer)o, searchLinkedFolders);
                        } else {
                            m.worked(scale);
                        }
                        ++k;
                    }
                }
            }
        }
        finally {
            m.done();
        }
    }

    private void findInDirectoryAndParents(IContainer container, File startPath) {
        File path = startPath;
        while (path != null && !this.ceilingDirectories.contains(path)) {
            this.findInDirectory(container, path);
            path = path.getParentFile();
        }
    }

    private void findInDirectory(IContainer container, File path) {
        if (GitTraceLocation.CORE.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.CORE.getLocation(), "Looking at candidate dir: " + path);
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        File parent = path.getParentFile();
        if (parent != null) {
            builder.addCeilingDirectory(parent);
        }
        builder.findGitDir(path);
        File gitDir = builder.getGitDir();
        if (gitDir != null) {
            this.register(container, gitDir);
        }
    }

    private void register(IContainer c, File gitdir) {
        File f = gitdir.getAbsoluteFile();
        if (this.gitdirs.contains(f)) {
            return;
        }
        this.gitdirs.add(f);
        this.results.add(new RepositoryMapping(c, f));
    }
}

