/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.recommenders.jayes.util.OrderIgnoringPair;

public class Graph
implements Cloneable {
    private List<List<Edge>> adjacency = new ArrayList<List<Edge>>();

    public List<List<Edge>> getAdjacency() {
        return this.adjacency;
    }

    public void initialize(int nodes) {
        this.adjacency.clear();
        int i = 0;
        while (i < nodes) {
            this.adjacency.add(new ArrayList());
            ++i;
        }
    }

    public Edge addEdge(int v1, int v2) {
        int i = 0;
        while (i < Math.max(v1, v2) - this.adjacency.size()) {
            this.adjacency.add(new ArrayList());
            ++i;
        }
        Edge e = new Edge(v1, v2);
        this.adjacency.get(v1).add(e);
        this.adjacency.get(v2).add(e.initializeBackEdge());
        return e;
    }

    public void removeEdge(Edge e) {
        this.adjacency.get((Integer)e.getFirst()).remove(e);
        this.adjacency.get((Integer)e.getSecond()).remove(e.getBackEdge());
    }

    public List<Edge> getIncidentEdges(int v) {
        return this.adjacency.get(v);
    }

    public static class Edge
    extends OrderIgnoringPair<Integer> {
        private Edge backEdge;

        public Edge(Integer o1, Integer o2) {
            super(o1, o2);
        }

        public Edge initializeBackEdge() {
            this.backEdge = new Edge((Integer)this.getSecond(), (Integer)this.getFirst());
            this.backEdge.backEdge = this;
            return this.getBackEdge();
        }

        public Edge getBackEdge() {
            return this.backEdge;
        }
    }
}

