/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.util.HashMap;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.NestedStatement;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.util.CompilerTools;
import org.mvel2.util.ParseTools;

public class IfNode
extends ASTNode
implements NestedStatement {
    protected char[] block;
    protected ExecutableStatement condition;
    protected ExecutableStatement nestedStatement;
    protected IfNode elseIf;
    protected ExecutableStatement elseBlock;

    public IfNode(char[] condition, char[] block, int fields, ParserContext pCtx) {
        super(pCtx);
        this.name = condition;
        if (condition == null || condition.length == 0) {
            throw new CompileException("statement expected");
        }
        this.block = block;
        if ((fields & 0x10) != 0) {
            this.condition = (ExecutableStatement)ParseTools.subCompileExpression(condition, pCtx);
            CompilerTools.expectType(pCtx, this.condition, Boolean.class, true);
            this.nestedStatement = (ExecutableStatement)ParseTools.subCompileExpression(block, pCtx);
        }
    }

    public IfNode(ExecutableStatement condition, ExecutableStatement nestedStatement, ExecutableStatement elseBlock) {
        super(((ASTNode)((Object)condition)).getParserContext());
        this.condition = condition;
        CompilerTools.expectType(this.pCtx, this.condition, Boolean.class, true);
        this.nestedStatement = nestedStatement;
        this.elseBlock = elseBlock;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (((Boolean)this.condition.getValue(ctx, thisValue, factory)).booleanValue()) {
            return this.nestedStatement.getValue(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseIf != null) {
            return this.elseIf.getReducedValueAccelerated(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseBlock != null) {
            return this.elseBlock.getValue(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (((Boolean)MVEL.eval(this.name, ctx, factory)).booleanValue()) {
            return MVEL.eval(this.block, ctx, (VariableResolverFactory)new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseIf != null) {
            return this.elseIf.getReducedValue(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseBlock != null) {
            return this.elseBlock.getValue(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        return null;
    }

    public ExecutableStatement getNestedStatement() {
        return this.nestedStatement;
    }

    public IfNode setElseIf(IfNode elseIf) {
        this.elseIf = elseIf;
        return this.elseIf;
    }

    public ExecutableStatement getElseBlock() {
        return this.elseBlock;
    }

    public IfNode setElseBlock(char[] block) {
        this.elseBlock = (ExecutableStatement)ParseTools.subCompileExpression(block, this.pCtx);
        return this;
    }

    public String toString() {
        return new String(this.name);
    }
}

