/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.integration;

import java.util.HashMap;
import java.util.Map;
import org.mvel2.integration.PropertyHandler;

public class PropertyHandlerFactory {
    protected static Map<Class, PropertyHandler> propertyHandlerClass = new HashMap<Class, PropertyHandler>();
    protected static PropertyHandler nullPropertyHandler;
    protected static PropertyHandler nullMethodHandler;

    public static PropertyHandler getPropertyHandler(Class clazz) {
        return propertyHandlerClass.get(clazz);
    }

    public static boolean hasPropertyHandler(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (!propertyHandlerClass.containsKey(clazz)) {
            Class clazzWalk = clazz;
            do {
                if (clazz != clazzWalk && propertyHandlerClass.containsKey(clazzWalk)) {
                    propertyHandlerClass.put(clazz, propertyHandlerClass.get(clazzWalk));
                    return true;
                }
                Class<?>[] classArray = clazzWalk.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> c = classArray[n2];
                    if (propertyHandlerClass.containsKey(c)) {
                        propertyHandlerClass.put(clazz, propertyHandlerClass.get(c));
                        return true;
                    }
                    ++n2;
                }
            } while ((clazzWalk = clazzWalk.getSuperclass()) != null && clazzWalk != Object.class);
            return false;
        }
        return true;
    }

    public static void registerPropertyHandler(Class clazz, PropertyHandler propertyHandler) {
        do {
            propertyHandlerClass.put(clazz, propertyHandler);
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c = classArray[n2];
                propertyHandlerClass.put(c, propertyHandler);
                ++n2;
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
    }

    public static void setNullPropertyHandler(PropertyHandler handler) {
        nullPropertyHandler = handler;
    }

    public static boolean hasNullPropertyHandler() {
        return nullPropertyHandler != null;
    }

    public static PropertyHandler getNullPropertyHandler() {
        return nullPropertyHandler;
    }

    public static void setNullMethodHandler(PropertyHandler handler) {
        nullMethodHandler = handler;
    }

    public static boolean hasNullMethodHandler() {
        return nullMethodHandler != null;
    }

    public static PropertyHandler getNullMethodHandler() {
        return nullMethodHandler;
    }

    public static void unregisterPropertyHandler(Class clazz) {
        propertyHandlerClass.remove(clazz);
    }

    public static void disposeAll() {
        nullMethodHandler = null;
        nullPropertyHandler = null;
        propertyHandlerClass.clear();
    }
}

