/* ArrayList
 *
 * Implementation of a homogeneous List using an array
 *
 * Operations:
 *  create
 *  destroy
 *  length
 *  size
 *  append
 *  prepend
 *  insert_at
 *  remove_at
 *  is_empty
 *  at(i)
 */

#pragma once

#include <stdlib.h>
#include <stdint.h>

typedef struct ArrayList_ {
    int *array;
    size_t length;
    size_t size;
} ArrayList;

ArrayList create(void);
void destroy(ArrayList array);
size_t length(const ArrayList array);
size_t size(const ArrayList array);
void append(ArrayList *array, const int elem);
void prepend(ArrayList *array, const int elem);
void insert_at(ArrayList *array, const int elem, const size_t i);
int remove_at(ArrayList *array, const size_t i);
int is_empty(const ArrayList array);
int at(const ArrayList array, const size_t i);
void print_list(const ArrayList array);
