#include <pthread.h>
#include <semaphore.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

int N = 20;

/* shared */
char choice;
pthread_mutex_t has_choice;

void draw(int total, int elapsed);
void *getasync(void *arg);

int main(void)
{
    pthread_mutex_init(&has_choice, NULL);
    pthread_mutex_lock(&has_choice);
    pthread_t tid;

    pthread_create(&tid, NULL, getasync, NULL);
    pthread_detach(tid);

    for (int i = 0; i < N; i++) {
        if (pthread_mutex_trylock(&has_choice) == 0) {
            if (choice == 'r') {
                puts("\nYou chose wisely.");
                return 0;
            } else {
                break;
            }
        }

        draw(N, i);
        sleep(1);
    }

    putchar('\n');
    puts("BOOM!");

    return 0;
}

void draw(int total, int elapsed)
{
    putchar('\r');
    putchar('[');
    for (int i = 0; i < total; i++) {
        if (i <= elapsed) {
            putchar('#');
        } else {
            putchar(' ');
        }
    }
    putchar(']');
    printf("%s", " red or blue? ");
    fflush(stdout);
}

void *getasync(void *arg)
{
    (void) arg;

    char c = getchar();
    choice = c;
    pthread_mutex_unlock(&has_choice);

    return NULL;
}
