#include <stdio.h>
#include <stdint.h>

uint32_t mystery2(uint32_t n, int i, uint8_t b) {
    uint32_t m = 0xFF << (i << 3);
    n &= ~m;
    n |= b << (i << 3);
    return n;
}

int main(void) {
    uint32_t n = 0x1A2B3C4D;
    int i = 4;
    uint8_t b = 0xAB;

    printf("mystery2(0x%08X, %d, 0x%02X) = 0x%08X\n", n, i, b, mystery2(n, i, b));
    printf("%08X\n", b << (i << 3));

    return 0;
}
