#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <pthread.h>

int N = 1000000000;
/* int N = 100; */

void sieve(bool *sieve);
void sieve_par(bool *is_prime);
void print_sieve(bool *sieve);
void *set_false_thread(void *data);

struct set_false_args {
    int start;
    int end;
    int incr;
    bool *is_prime;
};

int main(void)
{
    bool *is_prime = malloc(N * sizeof *is_prime);
    for (int i = 2; i < N; i++) {
        is_prime[i] = true;
    }

    /* sieve(is_prime); */
    sieve_par(is_prime);
    print_sieve(is_prime);

    free(is_prime);

    return 0;
}

void sieve(bool *is_prime)
{
    int sqrt_N = ceil(sqrt(N));
    for (int i = 2; i <= sqrt_N; i++) {
        if (is_prime[i]) {
            for (int j = i * 2; j < N; j += i) {
                is_prime[j] = false;
            }
        }
    }
}

void sieve_par(bool *is_prime)
{
    int sqrt_N = ceil(sqrt(N));
    for (int i = 2; i <= sqrt_N; i++) {
        if (is_prime[i]) {
            int range = (N - i * 2) / 2;
            struct set_false_args arg1 = {
                .start = i * 2,
                .end   = i + range,
                .incr  = i,
                .is_prime = is_prime
            };
            struct set_false_args arg2 = {
                .start = arg1.end,
                .end   = arg1.end + range,
                .incr  = i,
                .is_prime = is_prime
            };

            pthread_t id1, id2;
            pthread_create(&id1, NULL, set_false_thread, &arg1);
            pthread_create(&id2, NULL, set_false_thread, &arg2);
            pthread_join(id1, NULL);
            pthread_join(id2, NULL);
        }
    }
}

void *set_false_thread(void *data)
{
    struct set_false_args *args = data;
    int start = args->start;
    int end = args->end;
    int incr = args->incr;
    bool *is_prime = args->is_prime;

    int j = start;
    for (; j % incr != 0; j++);

    for (; j < end; j += incr) {
        is_prime[j] = false;
    }

    return NULL;
}


void print_sieve(bool *is_prime)
{
    int count = 0;
    for (int i = 0; i < N; i++) {
        if (is_prime[i]) {
            /* printf("%d\n", i); */
            count += 1;
        }
    }
    printf("count=%d\n", count);
}

