#include <pthread.h>
#include <stdio.h>
#include <stdbool.h>
#include <math.h>

const unsigned int N = 100000000;

unsigned count1 = 0;
unsigned count2 = 0;

bool is_prime(unsigned int n);

void *worker1(void *data);
void *worker2(void *data);


int main(void)
{
    pthread_t id1, id2;
    pthread_create(&id1, NULL, worker1, NULL);
    pthread_create(&id2, NULL, worker2, NULL);

    pthread_join(id1, NULL);
    pthread_join(id2, NULL);

    printf("count=%d\n", count1 + count2);

    return 0;
}

void *worker1(void *data)
{
    (void) data;
    unsigned int count = 0;
    for (unsigned int i = 0; i < N / 2; i++) {
        if (is_prime(i)) {
            count++;
        }
    }

    count1 = count;
    return NULL;
}

void *worker2(void *data)
{
    (void) data;
    unsigned int count = 0;
    for (unsigned int i = N / 2; i < N; i++) {
        if (is_prime(i)) {
            count++;
        }
    }

    count2 = count;

    return NULL;
}

bool is_prime(unsigned int n)
{
    if (n == 2) {
        return true;
    }

    unsigned int sqrt_n = ceil(sqrt(n));
    for (unsigned int i = 2; i <= sqrt_n; i++) {
        if (n % i == 0) {
            return false;
        }
    }

    return true;
}

