#!/usr/bin/env python3

import math

N = 10_000_000

def is_prime(n):
    if n == 2:
        return True

    for i in range(2, math.ceil(math.sqrt(n)) + 1):
        if n % i == 0:
            return False

    return True

def main():
    count = 0
    for i in range(2, N):
        if is_prime(i):
            count += 1
    print(f"count={count}")


if __name__ == '__main__':
    main()
