/* implementation of animals */

#include "animal.h"

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct cat {
        const char *name;
        /* other fields */
};

struct dog {
        const char *name;
        /* other fields */
};

enum animal_tag {
        CAT,
        DOG,
};

union animal_union {
        struct cat c;
        struct dog d;
};

struct animal {
        enum animal_tag tag;
        union animal_union animal;
};

struct animal *animal_create_cat(const char *name)
{
        struct animal *a = malloc(sizeof *a);
        a->animal.c.name = name;
        a->tag = CAT;

        return a;
}

struct animal *animal_create_dog(const char *name)
{
        struct animal *a = malloc(sizeof *a);
        a->animal.d.name = name;
        a->tag = DOG;

        return a;
}

void animal_free(struct animal *a)
{
        free(a);
}

const char *noise(struct animal *a)
{
        switch (a->tag) {
        case CAT:
                return "Meow";
        case DOG:
                return "Woof";
        default:
                return "Generic sine wave";
        }
}

void walk(struct animal *a)
{
        switch (a->tag) {
        case CAT:
                printf("%s walking\n", a->animal.c.name);
                break;
        case DOG:
                printf("%s walking\n", a->animal.d.name);
                break;
        default:
                printf("default walking\n");
                break;
        }
}

void reduce_noise(struct animal *a)
{
        char noise_buf[32];
        strcpy(noise_buf, noise(a));

        int len = strlen(noise_buf);
        for (int i = 0; i < len; i++) {
                noise_buf[i] = tolower(noise_buf[i]);
        }

        printf("%s\n", noise_buf);
}
