#define _GNU_SOURCE
#include "animal.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

void cat_free(struct animal *animal)
{
    struct cat *c = (struct cat *)animal;
    free(c->cat_breed);
    free(c);
}

void cat_noise(struct animal *animal)
{
    (void) animal;
    printf("%s\n", "Meow");
}

void cat_walk(struct animal *animal)
{
    struct cat *c = (struct cat *)animal;

    printf("cat %s, %s, walking\n", c->name, c->cat_breed);
}

void dog_free(struct animal *animal)
{
    struct dog *d = (struct dog *)animal;
    free(d);
}

void dog_noise(struct animal *animal)
{
    (void) animal;
    printf("%s\n", "Woof");
}

void dog_walk(struct animal *animal)
{
    struct dog *d = (struct dog *)animal;

    printf("dog %s, age %d, walking\n", d->name, d->dog_age);
}

struct animal_vtable CAT_VTABLE = {
    .free = &cat_free,
    .noise = &cat_noise,
    .walk = &cat_walk,
};

struct animal_vtable DOG_VTABLE = {
    .free = &dog_free,
    .noise = &dog_noise,
    .walk = &dog_walk,
};

struct animal *cat_create(const char *name, const char *breed)
{
    struct cat *self = malloc(sizeof *self);
    self->name = name;
    self->cat_breed = strdup(breed);

    self->vptr = &CAT_VTABLE;

    return (struct animal *) self;
}

struct animal *dog_create(const char *name, int age)
{
    struct dog *self = malloc(sizeof *self);
    self->name = name;
    self->dog_age = age;

    self->vptr = &DOG_VTABLE;
    return (struct animal *) self;
}

