#ifndef ANIMAL_H_
#define ANIMAL_H_

struct animal;

struct animal_vtable {
    void  (*free)(struct animal *animal);
    void  (*noise)(struct animal *animal);
    void  (*walk)(struct animal *animal);
};

struct animal {
    struct animal_vtable *vptr;
    const char *name;
};


struct cat {
    /* superclass's fields */
    struct animal_vtable *vptr;
    const char *name;

    /* cat's own fields */
    char *cat_breed;
};

struct dog {
    /* superclass's fields */
    struct animal_vtable *vptr;
    const char *name;

    /* dog's own fields */
    int dog_age;
};

struct animal *cat_create(const char *name, const char *breed);
struct animal *dog_create(const char *name, int age);

#endif

