#include <bitcoin/bitcoin.hpp>
#include <string.h>


//using namespace bc;

int main()
{
    /*
    Starting with STEP 0 from:  https://en.bitcoin.it/wiki/Technical_background_of_version_1_Bitcoin_addresses
    Private secret key string as base16
    */
    bc::ec_secret decoded;
    bc::decode_base16(decoded, "18e14a7b6a307f426a94f8114701e7c8e774e7f9a47e2c2035db29a206321725");
    std::cout << "Starting with ECDSA key from STEP 0: " << "18e14a7b6a307f426a94f8114701e7c8e774e7f9a47e2c2035db29a206321725" << std::endl;
    std::cout << "STAGE 0 is: " << "18e14a7b6a307f426a94f8114701e7c8e774e7f9a47e2c2035db29a206321725" << std::endl;

    bc::wallet::ec_private secret( decoded, bc::wallet::ec_private::mainnet_p2kh);
    std::cout << "secret: " << secret << std::endl;

    // Get keys
    bc::wallet::ec_public public_key(secret);
    std::cout << "Public key: " << public_key.encoded() << std::endl;
    std::cout << "STAGE 1 is: " << public_key.encoded() << std::endl;
    bc::wallet::ec_private private_key(secret);
    std::cout << "Private key: " << private_key.encoded() << std::endl;

    bc::ec_uncompressed point_decompressed;
    bc::decompress(point_decompressed, public_key.point());
    std::cout << "EC Point: " << bc::encode_base16(point_decompressed) <<std::endl;
    std::string s = bc::encode_base16(point_decompressed);
    std::cout << "s: " << s << std::endl;
    std::string x_value = s.substr(2,64);
    std::cout << "x coord: " << x_value << std::endl;
    std::string y_value = s.substr(66,64);
    std::cout << "y coord: " << y_value << std::endl;

    std::cout << "Public Key Compressed:" << std::endl;
    std::cout << public_key.encoded() << std::endl;
    return 0;
}

